﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.Model;
using System.Data;

namespace IndianHealthService.BMXNet.WinForm.Model
{
    internal class WinContext : WinObject, ChangableContext
    {
  
        public event EventHandler<ContextChangedArgs> Changed;

        public event EventHandler<ContextChangingArgs> Changing;


        public bool HasPatient
        {
            get { return this.Patient != null; }
        }

        public bool HasVisit
        {
            get { return this.Visit != null; }
        }

        public bool HasUnlockedVisit
        {
            get { return this.HasVisit && !this.Visit.IsLocked; }
        }

        private User _user = null;

        public User User
        {
            get { return _user; }
            set { _user = value; }
        }


        private WinVisit _desktopVisit;

        

internal WinVisit DesktopVisit
{
  get { return _desktopVisit; }
  set { _desktopVisit = value; }
}

private WinPatient _desktopPatient;

internal WinPatient DesktopPatient
{
    get { return _desktopPatient; }
    set { _desktopPatient = value; }
}
        public Visit Visit
        {
            get { return this.DesktopVisit; }
        }

        
        public Patient Patient
        {
            get { return this.DesktopPatient; }
        }


        public bool RequestCanChangePatient(Patient aPatient, bool force)
        {
            if (this.Changing != null)
            {
                ContextChangingArgs args = new ContextChangingArgs();
                args.IsPatientChange = true;
                args.Cancel = false;
                args.BeforeContext = this;
                this.Changing.Invoke(this, args);

                return !args.Cancel || force;
            }
            else
            {
                return true;
            }
        }


        public bool RequestCanChangeVisit(Visit aVisit, bool force)
        {
            if (this.Changing != null)
            {
                ContextChangingArgs args = new ContextChangingArgs();
                args.IsVisitChange = true;
                args.Cancel = false;
                args.BeforeContext = this;
                this.Changing.Invoke(this, args);

                return !args.Cancel || force;
            }
            else
            {
                return true;
            }
        }


        public bool ChangePatient(Patient aPatient)
        {       
            this.DesktopPatient= (WinPatient)aPatient;
            this.DesktopVisit= null;

            if (this.Changed != null)
            {
                ContextChangedArgs args = new ContextChangedArgs();
                args.IsPatientChange = true;
                args.AfterContext = this;
                this.Changed.Invoke(this, args);
            }
            return true;
        }

        public bool ChangeVisit(Visit aVisit)
        {      
            this.DesktopVisit = (WinVisit)aVisit;

            if (this.Changed != null)
            {
                ContextChangedArgs args = new ContextChangedArgs();
                args.IsVisitChange = true;
                args.AfterContext = this;
                this.Changed.Invoke(this, args);
            }
            return true;
        }
   

    }
}